#include "stdafx.h"
#include <float.h>

#include <archive\rpanim.h>
#include <rpmorph.h>
#include <rpskin.h>

#include "DffExp.h"

/* Function to convert a linked list of keyframes for bones sorted by time
   into an RpSkinAnim for RpSkin under PowerPipe. */
RpSkinAnim *
DFFExport::GenerateSkinAnimFromAnimKeyFrameList(AnimKeyFrameListEntry *keyFrameList, RwInt32 numBones)
{
    RwInt32 i;
    RpSkinAnim *anim = NULL;
    AnimKeyFrameListEntry *temp;
    AnimKeyFrameListEntry *prev;
    RwInt32 numFrames = 0;
    RwInt32 frameIndex = 0;
    RwReal early = FLT_MAX, late = -FLT_MAX;
    RwInt32 *framesLeft;
    RwReal *lastFrame;
    RpSkinFrame **lastFramePtr = NULL;

    framesLeft = (RwInt32 *)RwMalloc(sizeof(RwInt32) * numBones);
    lastFrame = (RwReal *)RwMalloc(sizeof(RwReal) * numBones);
    lastFramePtr = (RpSkinFrame **)RwMalloc(sizeof(RpSkinFrame *) * numBones);
    for (i=0; i<numBones; i++)
    {
        framesLeft[i] = 0;
        lastFrame[i] = 0;
        lastFramePtr[i] = NULL;
    }
    temp = keyFrameList->next;
    while (temp)
    {
        if (temp->time < early)
        {
            early = temp->time;
        }
        if (temp->time > late)
        {
            late = temp->time;
        }
        numFrames++;
        framesLeft[temp->bone]++;
        temp = temp->next;
    }
    anim = RpSkinAnimCreate(numFrames, 0, late - early);

    /* grab a first and second frame for each bone */
    for (i=0; i<numBones*2; i++)
    {
        prev = keyFrameList;
        temp = keyFrameList->next;
        while(temp->bone != (RwUInt32)(i % numBones))
        {
            prev = temp;
            temp = temp->next;
        }

        RWEXPMESSAGE(("%s(%d): bone: %d, time: %f\n", 
                      __FILE__, __LINE__,
                      temp->bone, temp->time));

        RtQuatConjugate(&anim->pFrames[frameIndex].q, &temp->q);
        anim->pFrames[frameIndex].t = temp->t;
        anim->pFrames[frameIndex].time = temp->time;
        anim->pFrames[frameIndex].prevFrame = lastFramePtr[temp->bone];
        lastFrame[temp->bone] = temp->time;
        lastFramePtr[temp->bone] = &anim->pFrames[frameIndex];
        frameIndex++;
        framesLeft[temp->bone]--;
        prev->next = temp->next;
        RwFree(temp);

    }
    
    /* now loop through until the list is empty
       finding which bone ends earliest but has
       frames remaining in the list */
    while(keyFrameList->next)
    {
        RwReal lastFrameTime = FLT_MAX;
        RwInt32 lastBone = -1;
        /* find the bone with the earliest last frame time */
        for (i=0; i<numBones; i++)
        {
            if (framesLeft[i] && lastFrame[i] < lastFrameTime)
            {
                lastFrameTime = lastFrame[i];
                lastBone = i;            
            }
        }

        /* find the first frame in the list for this bone,
           the list is time sorted */
        prev = keyFrameList;
        temp = keyFrameList->next;
        while((RwInt32)temp->bone != lastBone)
        {
            prev = temp;
            temp = temp->next;
        }

        RWEXPMESSAGE(("%s(%d): bone: %d, time: %f\n", 
                      __FILE__, __LINE__,
                      temp->bone, temp->time));

        RtQuatConjugate(&anim->pFrames[frameIndex].q, &temp->q);
        anim->pFrames[frameIndex].t = temp->t;
        anim->pFrames[frameIndex].time = temp->time;
        anim->pFrames[frameIndex].prevFrame = lastFramePtr[temp->bone];
        lastFrame[temp->bone] = temp->time;
        lastFramePtr[temp->bone] = &anim->pFrames[frameIndex];
        frameIndex++;        
        framesLeft[temp->bone]--;
        prev->next = temp->next;
        RwFree(temp);
    }

    RwFree(framesLeft);
    RwFree(lastFrame);
    RwFree(lastFramePtr);
    return anim;

}

